function P82_i
% Problem 8.2 :	The growth/decay of population of animal species
% i. Show x_n converges to zero when 0<r<1.

% Choose arbitrary r between 0 and 1
r=[0.1 0.5 0.7 0.9];
% Set initial population matrix 
x0=[0.1:0.1:0.9]';
% Set the population year
nf=15;
% Define color setr
col={'r' ; 'b' ; 'g' ; 'm'};

figure(1);
for j=1:length(r)
    % Set the normalized population matrix
    % row: different initial populatipon
    % column: population year n
    xn=zeros(length(x0),nf);
    % Calculate the quadratic recurrence equation 
    x=x0;
    for i=1:nf
        xn(:,i)=r(j)*x.*(1-x);
        x=xn(:,i);
    end
    % Plot the normalized population for n
    subplot(2,2,j);
    h=plot(0:nf,[x0 xn],[col{j} 's-']);
    set(h,'MarkerSize',6); 
    set(gca,'FontSize',18);
    grid on; axis tight;
    xlabel('\bfThe population at year (a.u.)');
    ylabel('\bfThe normalized population x_n (a.u.)');
    title(['\bfThe Normalized Population for r=' num2str(r(j))]);
end
end
    
    
